%function [x_axis,y_axis,z_axis] = get_Vbias_Vg
%% set the default font size for all figure
set(0,'defaultAxesFontSize',20)

%% ask the user to load the file
uiwait(msgbox('Choose the file you want to analyze'))
[fileName,pathName,~] = uigetfile('*.dat', 'Open file .dat');

%% get the data by reading the file
file = importdata(fullfile(pathName,fileName));

%% ask for the voltage bias amplification
prompt_Vbias = 'enter the dc Vbias module amplification in Volts';
dlgtitle_Vbias = 'Input';
user_val_Vbias = inputdlg(prompt_Vbias,dlgtitle_Vbias);
Vbias_val = str2num(user_val_Vbias{1});

%% ask for the lockin amplification
prompt_Vac = 'enter lockin amplification in Volts';
dlgtitle_Vac = 'Input';
user_val_Vac = inputdlg(prompt_Vac,dlgtitle_Vac);
Vac_val = str2num(user_val_Vac{1});

%% ask for the gate voltage
prompt_gate_voltage = 'enter the amplification for the gate voltage in Volts';
dlgtitle_gate_voltage = 'Input';
user_val_gate_voltage = inputdlg(prompt_gate_voltage,dlgtitle_gate_voltage);
gate_voltage_val = str2num(user_val_gate_voltage{1});

%% ask for the measured voltage amplification
prompt_Vmeas = 'enter the amplification for measured voltage in Volts';
dlgtitle_Vmeas = 'Input';
user_val_Vmeas = inputdlg(prompt_Vmeas,dlgtitle_Vmeas);
Vmeas_val = str2num(user_val_Vmeas{1});

%% ask for the measured current amplification
prompt_Imeas = 'enter the amplification for measured current in Amps';
dlgtitle_Imeas = 'Input';
user_val_Imeas = inputdlg(prompt_Imeas,dlgtitle_Imeas);
Imeas_val = str2num(user_val_Imeas{1});

%% Reading the size of Vbias 
str_Vbias = char(file.textdata(6));
str_split = strsplit(str_Vbias);
size_Vbias = str2num(str_split{3});

%% Getting Vbias values
Vbias = file.data(1:size_Vbias,1)*Vbias_val;

%% Reading the size of Vg
str_Vg = char(file.textdata(12));
str_split_Vg = strsplit(str_Vg);
size_Vg = str2num(str_split_Vg{3});

%% Getting the gate voltage values
r=1;
for i=1:size_Vg
    Vg(i)=file.data(r,2);
    r=r+size_Vbias;
end

%% Getting measured Voltage values (across the device) and measured current values
s=1;
Vmeasure = zeros(size_Vbias,size_Vg);
Imeasure = zeros(size_Vbias,size_Vg);
for i=1:size_Vg
    Vmeasure(1:size_Vbias,i)=file.data(s:s+size_Vbias-1,5)*Vmeas_val;
    Imeasure(1:size_Vbias,i)=file.data(s:s+size_Vbias-1,6)*Imeas_val;
    s=s+size_Vbias;
end

%% calculating the differential conductance in SI units
dIdV = Imeasure/Vac_val;
% dIdV = zeros(size_Vbias,size_Vg);
% for i=1:size_Vg
%     for j=2:size_Vbias-1
%         dIdV(j,i) = (Imeasure(j+1,i)-Imeasure(j-1,i))/(Vmeasure(j+1,i)-Vmeasure(j-1,i));
%         % dIdV(j,i) = (Imeasure(j+1,i)-Imeasure(j-1,i))/Vac_val;
%     end
% end
midpt=Vmeasure(round((size_Vbias+1)/2),1)*10^3;
figure;
x_axis = Vg*gate_voltage_val;
y_axis = Vbias(2:end-1)*10^3;% in mV
z_axis = transpose(dIdV(:,2:end-1));
figure1 = pcolor(x_axis,Vmeasure(2:end-1,:)*10^3-midpt,dIdV(2:end-1,:));
hold on
set(figure1, 'EdgeColor', 'none');
cl=colorbar;
% max_value = max(max(transpose(dIdV(:,2:end-1))));
% caxis([0 max_value])
%caxis([0 0.8*10^-5])
cl.Label.String = 'G (S)';
xlabel('$V_{g}(V)$','Interpreter','latex')
ylabel('$V_{bias}(mV)$','Interpreter','latex');

%end